<?php
require_once '../inc/config.php';
require_once '../inc/db.php';
require_once '../inc/date.php';
require_once '../inc/links.php';
require_once '../inc/functions.php';

if(isset($_GET['title'])) {$title= '"'.trim(str_replace("'","" ,str_replace('"','' ,strip_tags(stripslashes($_GET['title']))))).'"';}
$title=strtolower($title);
$title=str_replace("s","(s|",$title);
$title=str_replace("i","(i|î)",$title);
$title=str_replace("t","(t|ţ)",$title);
$title=str_replace("a","(a|â)",$title);
$title=str_replace(" ",".+",$title);
$title=str_replace('"',"",$title);
if(isset($_GET['autor'])) {$autor = strip_tags(stripslashes($_GET['autor']));}
if(isset($_GET['daterange']))  {
$range = $_GET['daterange'];
$date = explode(" - ", $range);
$from=strtotime($date[0]);
$to=strtotime($date[1]) +(24*3600-1);
}
if($title) {
$sql = 'SELECT COUNT(DISTINCT id) FROM articles WHERE  date BETWEEN :from AND :to AND (title REGEXP :title OR subtitle REGEXP :title  OR keywords REGEXP :title)  AND author=:autor';
}else {
$sql = 'SELECT COUNT(DISTINCT id) FROM articles WHERE  date BETWEEN :from AND :to AND  author=:autor';
}
$query = $dbh->prepare($sql);
if($title) {
$query->bindParam(':title',$title,PDO::PARAM_STR);
}
$query->bindParam(':autor',$autor,PDO::PARAM_STR);
$query->bindParam(':from',$from,PDO::PARAM_INT);
$query->bindParam(':to',$to,PDO::PARAM_INT);

$query->execute();
if ($query->rowCount())
{
$numart=$query->fetch(PDO::FETCH_NUM);
$numrows=$numart[0];
echo $numrows;
}
?>
<html>
<head>
<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" />

<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<body>
<div class="container" style="padding-top:50px;">

    <hgroup class="mb20">
        <h1>Rezultate Cautare</h1>
        <h2 class="lead"><strong class="text-danger"><?php echo $numrows ?></strong> rezultate au fost gasite pentru cautarea <strong class="text-danger"><?php echo $title?></strong></h2>
    </hgroup>

    <section class="col-xs-12 col-sm-6 col-md-12">
<?php
if($title) {
$query=$dbh->query("SELECT * FROM articles WHERE  date BETWEEN '$from' AND '$to' AND (title REGEXP '$title' OR subtitle REGEXP '$title' OR keywords REGEXP '$title') AND author='$autor' ");
}
$query =$dbh->query("SELECT * FROM articles WHERE  date BETWEEN '$from ' AND '$to' AND  author='$autor'");
foreach ($query as $article) {
$image = $article['image'];
$date = gmdate("d-m-Y",$article['date']);
$title = $article['title'];
$content  = strlen($article['content']) > 800 ? substr($article['content'],0,600)."..." : $article['content'];
if ($article['subcategory'] == 11) {
$stmt=$dbh->prepare('SELECT bigpic,realname FROM authors WHERE realname=:realname');
$stmt->bindParam(':realname',$article['author'],PDO::PARAM_STR);
$stmt->execute();
$author=$stmt->fetch(PDO::FETCH_ASSOC);
if ($author['bigpic']) {
$image =$author['bigpic'];
}
}
$cats= $dbh->query("SELECT name from categories where id=" . $article['category']. "");
foreach ($cats as $cat) {
    $categorie = $cat['name'];
    };

echo '<article class="search-result row">';
echo '            <div class="col-xs-12 col-sm-12 col-md-3">';
echo '                <a href="#" title="Lorem ipsum" class="thumbnail"><img src="' . $link . $image . '" alt="" /></a>';
echo '            </div>';
echo '            <div class="col-xs-12 col-sm-12 col-md-2">';
echo '                <ul class="meta-search">';
echo '                    <li><i class="glyphicon glyphicon-calendar"></i> <span>'. $date . '</span></li>';
echo '                    <li><i class="glyphicon glyphicon-tags"></i> <span>'. $categorie.'</span></li>';
echo '                </ul>';
echo '            </div>';
echo '            <div class="col-xs-12 col-sm-12 col-md-7 excerpet">';
echo '                <h3><a href="'.$link . linkme($article['title'],$article['id']).'" target="_blank"  title="">'.$article['title'] .'</a></h3>';
echo '            <p>' . $content . '</p>';
echo '                <span class="plus"><a href="http://www.cotidianul.ro/adm/publish.php?edit='.$article['id'].'" title="Editeaza"><i class="glyphicon glyphicon-plus"></i></a></span>';
echo '            </div>';
echo '            <span class="clearfix borda"></span>';
echo '        </article>';
}
?>




    </section>
</div>

</body>
</html>