<?php
require_once '../inc2/config.php';
require_once '../inc2/db.php';
require_once '../inc2/date.php';
require_once '../inc2/links.php';
require_once '../inc2/functions.php';
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">

<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" />

<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
<body>
<script type="text/javascript">
$(function() {

    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange').val(start.format('D-MM-YYYY') + ' - ' + end.format('D-MM-YYYY'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
	 locale: {
        format: 'D-MM-YYYY'
	},
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>

<div class="container">
<form action="excel.php" method="GET" class="form-horizontal" style="padding-top: 100px;">
<fieldset>

<!-- Form Name -->
<legend>Generare Raport</legend>
<div class="form-group">
<label class="col-md-4 control-label" for="Autor">Perioada</label>
 <div class="col-md-4">
<input  class="form-control input-md" type="text" name="daterange" id="reportrange" value="" />
</div>
</div>
<!-- Button -->
<div class="form-group">
  <label class="col-md-4 control-label" for="Cauta">Raport</label>
  <div class="col-md-4">
    <button id="Cauta" name="Genereaza" class="btn btn-primary">Genereaza</button>
  </div>
</div>

</fieldset>
</form>

</div>
</body>
</html>